/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndContainer;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.ProfileException;
import jade.imtp.leap.BackEndSkel;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.nio.NIOJICPConnection;
import jade.imtp.leap.nio.NIOMediator;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.net.InetAddress;

public class NIOBEDispatcher
implements NIOMediator,
BEConnectionManager,
Dispatcher {
    private static final long RESPONSE_TIMEOUT = 60000L;
    private long keepAliveTime;
    private boolean enableServerKeepAlive;
    private long lastReceivedTime;
    private boolean active = true;
    private boolean peerActive = true;
    private boolean connectionDropped = false;
    private JICPMediatorManager myMediatorManager;
    private String myID;
    private Properties myProperties;
    private BackEndContainer myContainer = null;
    protected InputManager inpManager;
    protected OutputManager outManager;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private Object shutdownLock = new Object();

    public String getID() {
        return this.active ? this.myID : null;
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public void init(JICPMediatorManager mgr, String id, Properties props) throws ICPException {
        this.myMediatorManager = mgr;
        this.myID = id;
        this.myProperties = props;
        long maxDisconnectionTime = 600000L;
        try {
            maxDisconnectionTime = Long.parseLong(props.getProperty("max-disconnection-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.keepAliveTime = 60000L;
        try {
            this.keepAliveTime = Long.parseLong(props.getProperty("keep-alive-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.enableServerKeepAlive = false;
        try {
            this.enableServerKeepAlive = Boolean.valueOf(props.getProperty("enable-server-keep-alive"));
        }
        catch (Exception e) {
            // empty catch block
        }
        int inpCnt = 0;
        try {
            inpCnt = Integer.parseInt(props.getProperty("lastsid")) + 1 & 0xF;
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Next command for FE will have sessionID " + inpCnt);
        int lastSid = 15;
        try {
            lastSid = (byte)(Integer.parseInt(props.getProperty("outcnt")) - 1);
            if (lastSid < 0) {
                lastSid = 15;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        FrontEndStub st = new FrontEndStub(this);
        this.inpManager = new InputManager(inpCnt, st);
        BackEndSkel sk = this.startBackEndContainer(props);
        this.outManager = new OutputManager(lastSid, sk, maxDisconnectionTime);
    }

    protected final BackEndSkel startBackEndContainer(Properties props) throws ICPException {
        try {
            String nodeName = this.myID.replace(':', '_');
            props.setProperty("container-name", nodeName);
            this.myContainer = new BackEndContainer(props, this);
            if (!this.myContainer.connect()) {
                throw new ICPException("BackEnd container failed to join the platform");
            }
            this.myID = this.myContainer.here().getName();
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "BackEndContainer " + this.myID + " successfully joined the platform");
            }
            return new BackEndSkel(this.myContainer);
        }
        catch (ProfileException pe) {
            pe.printStackTrace();
            throw new ICPException("Error creating profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                this.myContainer.shutDown();
            }
        }
    }

    public boolean handleIncomingConnection(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        this.checkTerminatedInfo(pkt);
        if (this.peerActive) {
            if (this.connectionDropped) {
                this.droppedToDisconnected();
            }
            this.lastReceivedTime = System.currentTimeMillis();
            boolean inp = false;
            byte[] data = pkt.getData();
            if (data.length == 1) {
                boolean bl = inp = data[0] == 1;
            }
            if (inp) {
                this.inpManager.setConnection(c);
                if (this.myLogger.isLoggable(Logger.CONFIG)) {
                    this.myLogger.log(Logger.CONFIG, this.myID + ": New INP Connection establishd");
                }
                ((NIOJICPConnection)c).configureBlocking();
            } else {
                this.outManager.setConnection(c);
                if (this.myLogger.isLoggable(Logger.CONFIG)) {
                    this.myLogger.log(Logger.CONFIG, this.myID + ": New OUT Connection establishd");
                }
            }
            return true;
        }
        this.kill();
        return false;
    }

    public void handleConnectionError(Connection c, Exception e) {
        block4: {
            if (!this.active || !this.peerActive) break block4;
            try {
                this.inpManager.checkConnection(c);
                this.myLogger.log(Logger.WARNING, this.myID + ": IC Disconnection detected");
                this.inpManager.resetConnection();
            }
            catch (ICPException icpe) {
                try {
                    this.outManager.checkConnection(c);
                    this.myLogger.log(Logger.WARNING, this.myID + ": OC Disconnection detected");
                    this.outManager.resetConnection();
                }
                catch (ICPException icpe2) {}
            }
        }
    }

    public JICPPacket handleJICPPacket(JICPPacket p, InetAddress addr, int port) throws ICPException {
        throw new ICPException("Unexpected call");
    }

    public JICPPacket handleJICPPacket(Connection c, JICPPacket pkt, InetAddress addr, int port) throws ICPException {
        if (pkt.getType() == 30) {
            this.handleDropDown(c, pkt, addr, port);
            return null;
        }
        this.checkTerminatedInfo(pkt);
        this.lastReceivedTime = System.currentTimeMillis();
        byte type = pkt.getType();
        if (type == 0) {
            if (this.peerActive) {
                return this.outManager.handleCommand(c, pkt);
            }
            this.kill();
            return null;
        }
        if (type == 2) {
            if (this.enableServerKeepAlive) {
                this.inpManager.sendServerKeepAlive();
            }
            return this.outManager.handleKeepAlive(c, pkt);
        }
        throw new ICPException("Unexpected packet type " + type);
    }

    public final void tick(long currentTime) {
        if (this.active && !this.connectionDropped) {
            this.inpManager.checkResponseTime(currentTime);
            if (this.keepAliveTime > 0L && currentTime - this.lastReceivedTime > this.keepAliveTime + 60000L) {
                if (this.outManager.isConnected()) {
                    this.myLogger.log(Logger.WARNING, this.myID + ": Missing keep-alive");
                    this.outManager.resetConnection();
                }
                if (this.inpManager.isConnected()) {
                    Thread t = new Thread(){

                        public void run() {
                            try {
                                NIOBEDispatcher.this.inpManager.sendServerKeepAlive();
                                if (NIOBEDispatcher.this.myLogger.isLoggable(Logger.CONFIG)) {
                                    NIOBEDispatcher.this.myLogger.log(Logger.CONFIG, NIOBEDispatcher.this.myID + ": IC valid");
                                }
                            }
                            catch (Exception e) {}
                        }
                    };
                    t.start();
                }
            }
            if (this.outManager.checkMaxDisconnectionTime(currentTime)) {
                this.myLogger.log(Logger.SEVERE, this.myID + ": Max disconnection time expired.");
                this.kill();
            }
        }
    }

    public FrontEnd getFrontEnd(BackEnd be, Properties props) throws IMTPException {
        return this.inpManager.getStub();
    }

    public void activateReplica(String addr, Properties props) throws IMTPException {
    }

    public void shutdown() {
        this.active = false;
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, this.myID + ": shutting down");
        }
        if (this.myID != null) {
            this.myMediatorManager.deregisterMediator(this.myID);
        }
        this.inpManager.shutdown();
        this.outManager.shutdown();
    }

    public byte[] dispatch(byte[] payload, boolean flush) throws ICPException {
        if (this.connectionDropped) {
            this.droppedToDisconnected();
            this.requestRefresh();
            throw new ICPException("Connection dropped");
        }
        JICPPacket pkt = new JICPPacket(0, 0, payload);
        pkt = this.inpManager.dispatch(pkt, flush);
        return pkt.getData();
    }

    protected void handleDropDown(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        block4: {
            if (this.myLogger.isLoggable(Logger.INFO)) {
                this.myLogger.log(Logger.INFO, this.myID + ": DROP_DOWN request received.");
            }
            try {
                if (this.inpManager.isConnected() && this.inpManager.isEmpty()) {
                    JICPPacket rsp = new JICPPacket(1, 0, null);
                    c.writePacket(rsp);
                    this.inpManager.resetConnection();
                    this.outManager.resetConnection();
                    this.connectionDropped = true;
                    break block4;
                }
                this.myLogger.log(Logger.WARNING, this.myID + ": DROP_DOWN request refused.");
                JICPPacket rsp = new JICPPacket(100, this.getReconnectInfo(), null);
                c.writePacket(rsp);
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, this.myID + ": Error writing DROP_DOWN response. " + e);
            }
        }
    }

    private void droppedToDisconnected() {
        this.connectionDropped = false;
        this.outManager.setExpirationDeadline();
    }

    protected void requestRefresh() {
    }

    public boolean isConnected() {
        return this.inpManager.isConnected() && this.outManager.isConnected();
    }

    private void updateConnectedState() {
        this.myProperties.put("connected", this.isConnected() ? "true" : "false");
    }

    private final byte getReconnectInfo() {
        byte info = 0;
        if (!this.inpManager.isConnected()) {
            info = (byte)(info | 0x10);
        }
        return info;
    }

    private final void checkTerminatedInfo(JICPPacket pkt) {
        if ((pkt.getInfo() & 0x40) != 0) {
            this.peerActive = false;
            if (this.myLogger.isLoggable(Logger.INFO)) {
                this.myLogger.log(Logger.INFO, this.myID + ": Peer termination notification received");
            }
        }
    }

    private void close(Connection c) {
        try {
            c.close();
        }
        catch (IOException ioe) {}
    }

    protected class OutputManager {
        private Connection myConnection;
        private JICPPacket lastResponse;
        private int lastSid;
        private BackEndSkel mySkel;
        private long maxDisconnectionTime;
        private long expirationDeadline;

        OutputManager(int n, BackEndSkel s, long t) {
            this.lastSid = n;
            this.mySkel = s;
            this.maxDisconnectionTime = t;
        }

        synchronized void setConnection(Connection c) {
            if (this.myConnection != null) {
                NIOBEDispatcher.this.close(this.myConnection);
            }
            this.myConnection = c;
            NIOBEDispatcher.this.updateConnectedState();
        }

        synchronized void resetConnection() {
            if (this.myConnection != null) {
                this.setExpirationDeadline();
                NIOBEDispatcher.this.close(this.myConnection);
            }
            this.myConnection = null;
            NIOBEDispatcher.this.updateConnectedState();
        }

        synchronized void setExpirationDeadline() {
            this.expirationDeadline = System.currentTimeMillis() + this.maxDisconnectionTime;
        }

        final void checkConnection(Connection c) throws ICPException {
            if (c != this.myConnection) {
                throw new ICPException("Wrong connection");
            }
        }

        final boolean isConnected() {
            return this.myConnection != null;
        }

        void shutdown() {
            this.resetConnection();
        }

        final synchronized JICPPacket handleCommand(Connection c, JICPPacket cmd) throws ICPException {
            this.checkConnection(c);
            JICPPacket reply = null;
            byte sid = cmd.getSessionID();
            if (sid == this.lastSid) {
                NIOBEDispatcher.this.myLogger.log(Logger.WARNING, NIOBEDispatcher.this.myID + ": Duplicated command from FE " + sid);
                reply = this.lastResponse;
            } else {
                if (NIOBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                    NIOBEDispatcher.this.myLogger.log(Logger.FINE, NIOBEDispatcher.this.myID + ": Received command " + sid + " from FE");
                }
                byte[] rspData = this.mySkel.handleCommand(cmd.getData());
                if (NIOBEDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                    NIOBEDispatcher.this.myLogger.log(Logger.FINER, NIOBEDispatcher.this.myID + ": Command " + sid + " from FE served ");
                }
                reply = new JICPPacket(1, NIOBEDispatcher.this.getReconnectInfo(), rspData);
                reply.setSessionID(sid);
                this.lastSid = sid;
                this.lastResponse = reply;
            }
            return reply;
        }

        synchronized JICPPacket handleKeepAlive(Connection c, JICPPacket command) throws ICPException {
            this.checkConnection(c);
            if (NIOBEDispatcher.this.myLogger.isLoggable(Logger.FINEST)) {
                NIOBEDispatcher.this.myLogger.log(Logger.FINEST, NIOBEDispatcher.this.myID + ": Keep-alive received");
            }
            return new JICPPacket(1, NIOBEDispatcher.this.getReconnectInfo(), null);
        }

        final synchronized boolean checkMaxDisconnectionTime(long currentTime) {
            return !this.isConnected() && currentTime > this.expirationDeadline;
        }
    }

    protected class InputManager {
        private Connection myConnection;
        private boolean dispatching = false;
        private boolean connectionRefreshed;
        private boolean waitingForFlush;
        private long readStartTime = -1L;
        private JICPPacket currentReply;
        private Object dispatchLock = new Object();
        private int inpCnt;
        private FrontEndStub myStub;

        InputManager(int c, FrontEndStub s) {
            this.inpCnt = c;
            this.myStub = s;
        }

        FrontEndStub getStub() {
            return this.myStub;
        }

        synchronized void setConnection(Connection c) {
            this.resetConnection();
            this.myConnection = c;
            this.connectionRefreshed = true;
            this.waitingForFlush = this.myStub.flush();
            NIOBEDispatcher.this.updateConnectedState();
        }

        synchronized void resetConnection() {
            if (this.myConnection != null) {
                NIOBEDispatcher.this.close(this.myConnection);
                this.myConnection = null;
            }
            NIOBEDispatcher.this.updateConnectedState();
        }

        final void checkConnection(Connection c) throws ICPException {
            if (c != this.myConnection) {
                throw new ICPException("Wrong connection");
            }
        }

        final boolean isConnected() {
            return this.myConnection != null;
        }

        final boolean isEmpty() {
            return !this.dispatching && this.myStub.isEmpty();
        }

        void shutdown() {
            this.resetConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final JICPPacket dispatch(JICPPacket pkt, boolean flush) throws ICPException {
            Object object = this.dispatchLock;
            synchronized (object) {
                this.dispatching = true;
                try {
                    JICPPacket jICPPacket;
                    InputManager inputManager = this;
                    synchronized (inputManager) {
                        if (!NIOBEDispatcher.this.active) throw new ICPException("Unreachable");
                        if (this.myConnection == null) throw new ICPException("Unreachable");
                        if (this.waitingForFlush && !flush) {
                            throw new ICPException("Unreachable");
                        }
                        this.waitingForFlush = false;
                        this.connectionRefreshed = false;
                    }
                    try {
                        pkt.setSessionID((byte)this.inpCnt);
                        if (NIOBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                            NIOBEDispatcher.this.myLogger.log(Logger.FINE, NIOBEDispatcher.this.myID + ": Sending command " + this.inpCnt + " to FE");
                        }
                        long start = System.currentTimeMillis();
                        this.myConnection.writePacket(pkt);
                        this.readStartTime = System.currentTimeMillis();
                        JICPPacket reply = this.myConnection.readPacket();
                        this.readStartTime = -1L;
                        NIOBEDispatcher.this.checkTerminatedInfo(reply);
                        NIOBEDispatcher.this.lastReceivedTime = System.currentTimeMillis();
                        long end2 = NIOBEDispatcher.this.lastReceivedTime;
                        System.out.println("INP Session " + this.inpCnt + ". Dispatching time = " + (end2 - start));
                        if (NIOBEDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                            NIOBEDispatcher.this.myLogger.log(Logger.FINER, NIOBEDispatcher.this.myID + ": Received response " + this.inpCnt + " from FE");
                        }
                        if (reply.getType() == 100) {
                            throw new ICPException(new String(pkt.getData()));
                        }
                        if (!NIOBEDispatcher.this.peerActive) {
                            NIOBEDispatcher.this.shutdown();
                        }
                        this.inpCnt = this.inpCnt + 1 & 0xF;
                        jICPPacket = reply;
                    }
                    catch (NullPointerException npe) {
                        throw new ICPException("Connection reset.");
                    }
                    catch (IOException ioe) {
                        InputManager inputManager2 = this;
                        synchronized (inputManager2) {
                            if (this.myConnection != null && !this.connectionRefreshed) {
                                NIOBEDispatcher.this.myLogger.log(Logger.WARNING, NIOBEDispatcher.this.myID + ": IOException IC. " + ioe);
                                this.resetConnection();
                            }
                        }
                        this.readStartTime = -1L;
                        throw new ICPException("Dispatching error.", ioe);
                    }
                    Object var13_11 = null;
                    this.dispatching = false;
                    return jICPPacket;
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    this.dispatching = false;
                    throw throwable;
                }
            }
        }

        public final void checkResponseTime(long currentTime) {
            if (this.readStartTime > 0L && currentTime - this.readStartTime > 60000L) {
                NIOBEDispatcher.this.myLogger.log(Logger.WARNING, NIOBEDispatcher.this.myID + ": Response timeout expired.");
                this.resetConnection();
            }
        }

        public void sendServerKeepAlive() throws ICPException {
            JICPPacket pkt = new JICPPacket(2, 0, null);
            this.dispatch(pkt, false);
        }
    }
}

